import { clone } from 'ramda';

/**
 * 克隆方法
 * @param {Record<any, any>} data
 * @return {*}  {Record<any, any>}
 */
export function deepCopy(data: Record<any, any>): Record<any, any> {
  return clone(data);
}

/**
 * 除undefined，null,NaN以外都为true
 * @param {*} arg
 * @return {*}  {boolean}
 */
export function hasValue(arg: any): boolean {
  return arg !== undefined && arg !== null && arg === arg;
}

/**
 * 判断是否是对象
 * @param val
 * @return {*} 
 */
export function isObject(val: any) {
  return val !== null && typeof val === 'object';
}
